{* templates/six/homepage.tpl *}

<div class="home-hero text-center">
    <div class="container">
        <h1>{lang key='clientHomePanels.productsAndServices'}</h1>
        <p>Fast, Reliable & Secure Hosting Solutions</p>
        <a href="cart.php" class="btn btn-primary btn-lg mt-3">
            {lang key='browseProducts'}
        </a>
    </div>
</div>

{if !empty($productGroups) || $registerdomainenabled || $transferdomainenabled}
    <div class="container my-5 homepage-cards">
        <div class="row">
            {foreach $productGroups as $productGroup}
                <div class="col-md-4 mb-4">
                    <div class="card h-100 text-center">
                        <div class="card-header">
                            {$productGroup->name}
                        </div>
                        <div class="card-body d-flex flex-column">
                            <p class="flex-grow-1">{$productGroup->tagline}</p>
                            <a href="{$productGroup->getRoutePath()}" class="btn btn-primary mt-auto">
                                {lang key='browseProducts'}
                            </a>
                        </div>
                    </div>
                </div>
            {/foreach}

            {if $registerdomainenabled}
                <div class="col-md-4 mb-4">
                    <div class="card h-100 text-center">
                        <div class="card-header">
                            {lang key='orderregisterdomain'}
                        </div>
                        <div class="card-body d-flex flex-column">
                            <p class="flex-grow-1">{lang key='secureYourDomain'}</p>
                            <a href="{$WEB_ROOT}/cart.php?a=add&domain=register" class="btn btn-primary mt-auto">
                                {lang key='navdomainsearch'}
                            </a>
                        </div>
                    </div>
                </div>
            {/if}

            {if $transferdomainenabled}
                <div class="col-md-4 mb-4">
                    <div class="card h-100 text-center">
                        <div class="card-header">
                            {lang key='transferYourDomain'}
                        </div>
                        <div class="card-body d-flex flex-column">
                            <p class="flex-grow-1">{lang key='transferExtend'}</p>
                            <a href="{$WEB_ROOT}/cart.php?a=add&domain=transfer" class="btn btn-primary mt-auto">
                                {lang key='transferYourDomain'}
                            </a>
                        </div>
                    </div>
                </div>
            {/if}
        </div>
    </div>
{/if}

<div class="home-announcements py-5">
    <div class="container">
        <h2 class="text-center mb-4">{lang key='howCanWeHelp'}</h2>
        <div class="row action-icon-btns">
            <div class="col-6 col-md-4 col-lg">
                <a href="{routePath('announcement-index')}" class="card-accent-teal">
                    <figure class="ico-container">
                        <i class="fal fa-bullhorn"></i>
                    </figure>
                    {lang key='announcementstitle'}
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg">
                <a href="serverstatus.php" class="card-accent-pomegranate">
                    <figure class="ico-container">
                        <i class="fal fa-server"></i>
                    </figure>
                    {lang key='networkstatustitle'}
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg">
                <a href="{routePath('knowledgebase-index')}" class="card-accent-sun-flower">
                    <figure class="ico-container">
                        <i class="fal fa-book"></i>
                    </figure>
                    {lang key='knowledgebasetitle'}
                </a>
            </div>
            <div class="col-6 col-md-4 offset-md-2 offset-lg-0 col-lg">
                <a href="{routePath('download-index')}" class="card-accent-asbestos">
                    <figure class="ico-container">
                        <i class="fal fa-download"></i>
                    </figure>
                    {lang key='downloadstitle'}
                </a>
            </div>
            <div class="col-6 offset-3 offset-md-0 col-md-4 col-lg">
                <a href="submitticket.php" class="card-accent-green">
                    <figure class="ico-container">
                        <i class="fal fa-life-ring"></i>
                    </figure>
                    {lang key='homepage.submitTicket'}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="container py-5">
    <h2 class="text-center mb-4">{lang key='homepage.yourAccount'}</h2>
    <div class="row action-icon-btns">
        <div class="col-6 col-md-4 col-lg">
            <a href="clientarea.php" class="card-accent-midnight-blue">
                <figure class="ico-container">
                    <i class="fal fa-home"></i>
                </figure>
                {lang key='homepage.yourAccount'}
            </a>
        </div>
        <div class="col-6 col-md-4 col-lg">
            <a href="clientarea.php?action=services" class="card-accent-midnight-blue">
                <figure class="ico-container">
                    <i class="far fa-cubes"></i>
                </figure>
                {lang key='homepage.manageServices'}
            </a>
        </div>
        {if $registerdomainenabled || $transferdomainenabled || $numberOfDomains}
            <div class="col-6 col-md-4 col-lg">
                <a href="clientarea.php?action=domains" class="card-accent-midnight-blue">
                    <figure class="ico-container">
                        <i class="fal fa-globe"></i>
                    </figure>
                    {lang key='homepage.manageDomains'}
                </a>
            </div>
        {/if}
        <div class="col-6 col-md-4 offset-md-2 offset-lg-0 col-lg">
            <a href="supporttickets.php" class="card-accent-midnight-blue">
                <figure class="ico-container">
                    <i class="fal fa-comments"></i>
                </figure>
                {lang key='homepage.supportRequests'}
            </a>
        </div>
        <div class="col-6 offset-3 offset-md-0 col-md-4 col-lg">
            <a href="clientarea.php?action=masspay&all=true" class="card-accent-midnight-blue">
                <figure class="ico-container">
                    <i class="fal fa-credit-card"></i>
                </figure>
                {lang key='homepage.makeAPayment'}
            </a>
        </div>
    </div>
</div>
