<?php

use WHMCS\Database\Capsule;

add_hook('TicketOpen', 1, function($vars) {
    $ticketId = $vars['ticketid'];
    $clientId = $vars['userid'];

    // Fetch client info
    $client = Capsule::table('tblclients')->where('id', $clientId)->first();

    // Prepare Chatwoot payload
    $payload = [
        'source_id' => 'whmcs-ticket-' . $ticketId,
        'inbox_id' => 1, // ID of your Chatwoot inbox
        'contact' => [
            'name'  => $client ? $client->firstname . ' ' . $client->lastname : 'WHMCS User',
            'email' => $client ? $client->email : null,
        ],
        'messages' => [
            [
                'content' => $vars['message'],
                'private' => false
            ]
        ]
    ];

    // Chatwoot API URL (use your self-hosted domain)
    $chatwootUrl = 'https://www.msn.nestict.net/api/v1/accounts/1/conversations';
    $apiAccessToken = 'YOUR_CHATWOOT_API_ACCESS_TOKEN'; // Generate from Chatwoot Dashboard

    // Send POST to Chatwoot
    $ch = curl_init($chatwootUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'api_access_token: ' . $apiAccessToken
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    $response = curl_exec($ch);
    curl_close($ch);
});