<?php
// chatwoot-dashboard.php
// Embedded WHMCS dashboard view for Chatwoot agents

use WHMCS\Database\Capsule;

require __DIR__ . '/init.php';

header('Content-Type: text/html; charset=UTF-8');

// Sanitize incoming data
$email = filter_input(INPUT_GET, 'email', FILTER_SANITIZE_EMAIL);
$phone = filter_input(INPUT_GET, 'phone', FILTER_SANITIZE_STRING);
$identifier = filter_input(INPUT_GET, 'identifier', FILTER_SANITIZE_STRING);

echo "<html><head>
    <style>
        body { font-family: Arial, sans-serif; padding: 10px; }
        h2 { margin-top: 0; color: #1f2937; }
        .info { background: #f1f5f9; padding: 10px; border-radius: 8px; margin-bottom: 10px; }
        .ticket { border: 1px solid #ddd; padding: 8px; border-radius: 5px; margin-bottom: 5px; }
        .ticket h4 { margin: 0; }
    </style>
</head><body>";

echo "<h2>Web-Hosting Billing Info</h2>";

if ($email) {
    // Lookup WHMCS client by email
    $client = Capsule::table('tblclients')->where('email', $email)->first();
    if ($client) {
        echo "<div class='info'>";
        echo "<strong>Name:</strong> {$client->firstname} {$client->lastname}<br>";
        echo "<strong>Email:</strong> {$client->email}<br>";
        echo "<strong>Status:</strong> {$client->status}<br>";
        echo "<strong>Balance:</strong> {$client->credit} KES<br>";
        echo "</div>";

        // Fetch last 5 tickets
        $tickets = Capsule::table('tbltickets')
            ->where('userid', $client->id)
            ->orderBy('date', 'desc')
            ->limit(5)
            ->get();

        echo "<h3>Recent Tickets</h3>";
        foreach ($tickets as $t) {
            echo "<div class='ticket'>";
            echo "<h4>[#{$t->tid}] {$t->title}</h4>";
            echo "<small>{$t->status} | {$t->date}</small>";
            echo "</div>";
        }

    } else {
        echo "<p>No WHMCS client found for <strong>{$email}</strong></p>";
    }
} else {
    echo "<p>No email provided in Chatwoot data.</p>";
}

echo "</body></html>";