<?php
// admin/nestict_mpesa_requests.php
require_once __DIR__ . '/../init.php';
use WHMCS\Database\Capsule;

session_start();

if (!isset($_SESSION['adminid']) || empty($_SESSION['adminid'])) {
    header('Location: index.php');
    exit;
}

// CSV export
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="mpesa_requests_' . date('Ymd_His') . '.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['id','merchant_request_id','checkout_request_id','invoice_id','phone','amount','status','created_at']);
    $rows = Capsule::table('tblmpesarequests')->orderBy('created_at', 'desc')->get();
    foreach ($rows as $r) {
        fputcsv($out, [
            $r->id,
            $r->merchant_request_id,
            $r->checkout_request_id,
            $r->invoice_id,
            $r->phone,
            $r->amount,
            $r->status,
            $r->created_at,
        ]);
    }
    fclose($out);
    exit;
}

$rows = Capsule::table('tblmpesarequests')->orderBy('created_at', 'desc')->limit(300)->get();
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Nestict M-Pesa Requests</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; font-size: 13px; }
        th { background: #f5f5f5; }
        .btn { padding: 6px 10px; text-decoration: none; border-radius: 4px; background: #2c7; color: #fff; }
    </style>
</head>
<body>
    <h2>Nestict M-Pesa STK Requests</h2>
    <p><a href="nestict_mpesa_requests.php?export=csv" class="btn">Export CSV</a> &nbsp; <a href="index.php" class="btn" style="background:#3b7">Back to Admin</a></p>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>MerchantRequestID</th>
                <th>CheckoutRequestID</th>
                <th>Invoice ID</th>
                <th>Phone</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Created At</th>
                <th>Raw Response</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
            <tr>
                <td><?php echo htmlspecialchars($r->id); ?></td>
                <td><?php echo htmlspecialchars($r->merchant_request_id); ?></td>
                <td><?php echo htmlspecialchars($r->checkout_request_id); ?></td>
                <td><?php if ($r->invoice_id): ?><a href="invoices.php?action=view&id=<?php echo intval($r->invoice_id); ?>" target="_blank"><?php echo intval($r->invoice_id); ?></a><?php else: echo '-'; endif; ?></td>
                <td><?php echo htmlspecialchars($r->phone); ?></td>
                <td><?php echo htmlspecialchars($r->amount); ?></td>
                <td><?php echo htmlspecialchars($r->status); ?></td>
                <td><?php echo htmlspecialchars($r->created_at); ?></td>
                <td>
                    <button onclick="toggleRaw(<?php echo intval($r->id); ?>)">View</button>
                    <div id="raw-<?php echo intval($r->id); ?>" style="display:none; margin-top:6px; max-width:600px; white-space:pre-wrap; background:#f9f9f9; padding:8px; border:1px solid #eee;"><?php echo htmlspecialchars($r->response); ?></div>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<script>
function toggleRaw(id){
    var el = document.getElementById('raw-' + id);
    if (!el) return;
    el.style.display = (el.style.display === 'none' ? 'block' : 'none');
}
</script>
</body>
</html>
